/* OHRRPGCE - scancode constants
 * (C) Copyright 1997-2020 James Paige, Ralph Versteegen, and the OHRRPGCE Developers
 * Dual licensed under the GNU GPL v2+ and MIT Licenses. Read LICENSE.txt for terms and disclaimer of liability.
 */

#ifndef SCANCODES_H
#define SCANCODES_H

#define SC_ESC			1
#define SC_1			2
#define SC_EXCLAMATION		2
#define SC_2			3
#define SC_ATSIGN		3
#define SC_3			4
#define SC_HASH			4
#define SC_4			5
#define SC_DOLLARSIGN		5
#define SC_5			6
#define SC_PERCENT		6
#define SC_6			7
#define SC_CIRCUMFLEX		7
#define SC_7			8
#define SC_AMPERSAND		8
#define SC_8			9
#define SC_ASTERISK		9
#define SC_9			10
#define SC_LEFTPARENTHESIS     	10
#define SC_0			11
#define SC_RIGHTPARENTHESIS    	11
#define SC_MINUS		12
#define SC_UNDERSCORE		12
#define SC_EQUALS		13
#define SC_PLUS			13
#define SC_BACKSPACE		14
#define SC_TAB			15
#define SC_Q			16
#define SC_W			17
#define SC_E			18
#define SC_R			19
#define SC_T			20
#define SC_Y			21
#define SC_U			22
#define SC_I			23
#define SC_O			24
#define SC_P			25
#define SC_LEFTBRACKET		26
#define SC_LEFTBRACE		26
#define SC_RIGHTBRACKET		27
#define SC_RIGHTBRACE		27
#define SC_ENTER		28
#define SC_CTRL			29
#define SC_A			30
#define SC_S			31
#define SC_D			32
#define SC_F			33
#define SC_G			34
#define SC_H			35
#define SC_J			36
#define SC_K			37
#define SC_L			38
#define SC_SEMICOLON   		39
#define SC_COLON		39
#define SC_QUOTE		40
#define SC_DOUBLEQUOTE		40
#define SC_APOSTROPHE		40
#define SC_BACKQUOTE		41
#define SC_TILDE		41
#define SC_LEFTSHIFT		42
#define SC_BACKSLASH		43
#define SC_PIPE			43
#define SC_Z			44
#define SC_X			45
#define SC_C			46
#define SC_V			47
#define SC_B			48
#define SC_N			49
#define SC_M			50
#define SC_COMMA		51
#define SC_LEFTCARET		51
#define SC_PERIOD		52
#define SC_RIGHTCARET		52
#define SC_SLASH	       	53
#define SC_QUESTIONMARK		53
#define SC_RIGHTSHIFT		54
#define SC_NUMPADASTERISK      	55
#define SC_ALT			56
#define SC_SPACE	       	57
#define SC_CAPSLOCK		58
#define SC_F1			59
#define SC_F2			60
#define SC_F3			61
#define SC_F4			62
#define SC_F5			63
#define SC_F6			64
#define SC_F7			65
#define SC_F8			66
#define SC_F9			67
#define SC_F10			68
#define SC_NUMLOCK		69
#define SC_SCROLLLOCK		70
#define SC_HOME			71
#define SC_UP			72
#define SC_PAGEUP		73
#define SC_NUMPADMINUS		74
#define SC_LEFT			75
#define SC_RIGHT		77
#define SC_NUMPADPLUS		78
#define SC_END			79
#define SC_DOWN			80
#define SC_PAGEDOWN		81
#define SC_INSERT		82
#define SC_DELETE		83
#define SC_F11			87
#define SC_F12			88
#define SC_LEFTWINLOGO		91
#define SC_LEFTCOMMAND		91
#define SC_LEFTMETA		91
#define SC_RIGHTWINLOGO		92
#define SC_RIGHTCOMMAND		92
#define SC_RIGHTMETA		92
#define SC_CONTEXT		93

// The following scancodes deviate from QB/FB

#define SC_F13			94
#define SC_F14			95
#define SC_F15			96

#define SC_SHIFT		97
#define SC_LEFTALT		98
#define SC_RIGHTALT		99
#define SC_LEFTCTRL		100
#define SC_RIGHTCTRL		101

#define SC_NUMPADSLASH		102
#define SC_NUMPADENTER		103

#define SC_NUMPAD7		104
#define SC_NUMPAD8		105
#define SC_NUMPAD9		106
#define SC_NUMPAD4		108
#define SC_NUMPAD5		109
#define SC_NUMPAD6		110
#define SC_NUMPAD1		112
#define SC_NUMPAD2		113
#define SC_NUMPAD3		114
#define SC_NUMPAD0		115
#define SC_NUMPADPERIOD		116

#define SC_PRINTSCREEN		117
#define SC_PAUSE		118


#endif
