namespace ucstypes
------------------------------------------
--  Unicode Character Types

--  The following is taken from AndroidUnicode.h, AndroidUnicode.cpp and
--  characterData.h from the Andriod project
-- 
--  *
--  * Copyright (C) 2008 The Android Open Source Project
--  *
--  * Licensed under the Apache License, Version 2.0 (the "License");
--  * you may not use this file except in compliance with the License.
--  * You may obtain a copy of the License at
--  *
--  *      http://www.apache.org/licenses/LICENSE-2.0
--  *
--  * Unless required by applicable law or agreed to in writing, software
--  * distributed under the License is distributed on an "AS IS" BASIS,
--  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  * See the License for the specific language governing permissions and
--  * limitations under the License.
--  * 

include std/types.e 
include std/math.e
include std/utils.e

-- For Latin1 characters just index into this array to get the index and decomposition
constant LATIN1_DATA = u"
	0001 0001 0001 0001 0001 0001 0001 0001
	0001 0002 0003 0002 0004 0003 0001 0001
	0001 0001 0001 0001 0001 0001 0001 0001
	0001 0001 0001 0001 0003 0003 0003 0002
	0005 0006 0006 0007 0008 0007 0006 0006
	0009 000A 0006 000B 000C 000D 000C 000C
	000E 000F 0010 0011 0012 0013 0014 0015
	0016 0017 000C 0006 0018 0019 001A 0006
	0006 001B 001C 001D 001E 001F 0020 0021
	0022 0023 0024 0025 0026 0027 0028 0029
	002A 002B 002C 002D 002E 002F 0030 0031
	0032 0033 0034 0035 0006 0036 0037 0038
	0037 0039 003A 003B 003C 003D 003E 003F
	0040 0041 0042 0043 0044 0045 0046 0047
	0048 0049 004A 004B 004C 004D 004E 004F
	0050 0051 0052 0035 0019 0036 0019 0001
	0001 0001 0001 0001 0001 0003 0001 0001
	0001 0001 0001 0001 0001 0001 0001 0001
	0001 0001 0001 0001 0001 0001 0001 0001
	0001 0001 0001 0001 0001 0001 0001 0001
	5853 0006 0008 0008 0008 0008 0054 0054
	1037 0054 7855 0056 0019 0057 0054 1037
	0058 0059 785A 785B 1037 105C 0054 0006
	1037 785D 7855 005E 305F 305F 305F 0006
	0860 0860 0860 0860 0860 0860 0060 0860
	0860 0860 0860 0860 0860 0860 0860 0860
	0060 0860 0860 0860 0860 0860 0860 0019
	0060 0860 0860 0860 0860 0860 0060 0055
	0861 0861 0861 0861 0861 0861 0061 0861
	0861 0861 0861 0861 0861 0861 0861 0861
	0061 0861 0861 0861 0861 0861 0861 0019
	0061 0861 0861 0861 0861 0861 0061 0862
"

-- Each of these arrays is stripped into ranges. In order to build the arrays, each
-- codepoint was bit-shifted so that even and odd characters were separated into different
-- arrays. The identifier of each array is the top byte after bit-shifting.
-- The numbers stored in the array are the bit-shifted codepoint, the decomposition, and an
-- index into another array of all possible packed data values. The top 16 bits are the
-- codepoint and the bottom 16 are the decomposition and index. The top 5 bits for the decomposition
-- and the rest for the index.
constant a0 = U"
	00800863 00880063 00890863 00930063 00940863 00980864 00991063 009A0863
	009C0055 009D0865 00A01065 00A10065 00A20865 00A50063 00A60863 00A90063
	00AA0863 00B30063 00B40863 00BC0866 00BD0865 00C00055 00C10063 00C30067
	00C40065 00C50068 00C60065 00C70069 00C8006A 00C90065 00CA006B 00CB006C
	00CC0063 00CD006D 00CE006C 00CF006E 00D00863 00D10063 00D3006F 00D40065
	00D50055 00D60063 00D7006F 00D80865 00D90070 00DA0065 00DC0063 00DD0055
	00DE0063 00DF0055 00E00071 00E21072 00E31073 00E41074 00E51072 00E61073
	00E70865 00EF0863 00F20063 00F30863 00F80855 00F91074 00FA0863 00FB0075
	00FC0863 010E0063 010F0863 01100076 01110063 01130863 011A0055 011D0077
	011E0065 011F0077 01200055 01210078 01280055 012A0079 012B007A 012C0055
	0130007A 01310055 0134007B 01350055 0139007C 013A0055 0140007D 01410055
	0144007D 0145007E 01460055 0149007F 014A0080 014B0055 01587881 015D0082
	015E0081 01610037 01630082 01680081 01690037 016C1037 016F0037 01707881
	01730037 01770081 01780037 01800083 01A00883 01A10083 01A20883 01A30083
	01B80078 01BA0837 01BB0078 01BD1081 01BE0078 01BF0806 01C00078 01C21037
	01C30884 01C40885 01C60886 01C70887 01C80855 01C90060 01D10078 01D20060
	01D50860 01D60888 01D70889 01D80855 01D90061 01E1008A 01E20061 01E50861
	01E6088B 01E7088C 01E8108D 01E91077 01EA0877 01EB108E 01EC0063 01F8108F
	01F91090 01FA1091 01FB0019 01FC0065 01FD0063 01FE0055 01FF0077 02000892
	02010092 02060892 02080060 02180061 02280893 02290093 022E0893 02300063
	023B0863 023C0063 02410094 02420083 02440095 02450063 02600077 02610865
	02620065 02680863 026A0063 026B0863 026C0063 026D0863 02700063 02710863
	02740063 02750863 027B0063 027C0863 027D0078 02800063 02880078 02990096
	02AC0078 02AD0097 02B00078 02B10098 02C40078 02C50099 02C60078 02C90083
	02DD0078 02DE0083 02DF009A 02E10083 02E3009A 02E40078 02E8009B 02F60078
	02F8009B 02FA009A 02FB0078 0300009C 03020078 0306000C 03070054 03080083
	030B0078 030F009D 03100078 0311089E 0314009E 031E0078 0320009F 0321009E
	03260083 033000A0 033100A1 033200A2 033300A3 033400A4 03350007 033600A5
	0337009E 03380083 0339009E 033B109E 033D009E 0360089E 0362009E 036A009D
	036B0083 036F0095 03700083 0373009F 03740083 0377009E 0378000E 03790010
	037A0012 037B0014 037C0016 037D009E 037F00A6 0380009D 03870078 0388009E
	03980083 03A60078 03A7009E 03B70078 03C0009E 03D30083 03D90078 04810083
	04820071 049A0871 049B0071 049D0078 049E0083 049F00A7 04A10083 04A500A7
	04A70078 04A80071 04A90083 04AB0078 04AC0871 04B00071 04B10083 04B20097
	04B300A8 04B400A9 04B500AA 04B600AB 04B700AC 04B80097 04B90078 04C100A7
	04C20078 04C30071 04C70078 04C80071 04C90078 04CA0071 04DA0078 04DB0071
	04DD0078 04DE0083 04DF00A7 04E10083 04E30078 04E400A7 04E50078 04E608A7
	04E70071 04E80078 04EE0871 04EF0078 04F00071 04F10083 04F20078 04F300A8
	04F400A9 04F500AA 04F600AB 04F700AC 04F80071 04F90008 04FA00AD 04FB00AE
	04FC00AF 04FD0094 04FE0078 05010083 05020078 05030071 05060078 05080071
	05090078 050A0071 051A0078 051B0871 051C0071 051D0078 051E0083 051F00A7
	05210083 05220078 05240083 05250078 05260083 05270078 052D0871 052E0071
	052F0871 05300078 053300A8 053400A9 053500AA 053600AB 053700AC 05380083
	05390071 053B0078 05410083 05420078 05430071 05470078 05480071 05490078
	054A0071 055A0078 055B0071 055D0078 055E0083 055F00A7 05610083 05630078
	05640083 05650078 056600A7 05670078 05680071 05690078 05700071 05710083
	05720078 057300A8 057400A9 057500AA 057600AB 057700AC 05780078 058100A7
	05820078 05830071 05870078 05880071 05890078 058A0071 059A0078 059B0071
	059D0078 059E0083 059F00A7 05A10083 05A20078 05A408A7 05A50078 05A608A7
	05A70078 05AB0083 05AC0078 05AE0871 05AF0078 05B00071 05B10078 05B300A8
	05B400A9 05B500AA 05B600AB 05B700AC 05B80094 05B90078 05C10083 05C20078
	05C30071 05C60078 05C70071 05CA0871 05CB0078 05CD0071 05D00078 05D20071
	05D30078 05D40071 05D60078 05D70071 05DD0078 05DF00A7 05E00083 05E100A7
	05E20078 05E300A7 05E508A7 05E70078 05F300A8 05F400A9 05F500AA 05F600AB
	05F700AC 05F800B0 05F900B1 05FA0054 05FE0078 060100A7 06020078 06030071
	061A0078 061B0071 061D0078 061F0083 062100A7 06230083 06240883 06250083
	06270078 062B0083 062C0078 06300071 06310078 063300A8 063400A9 063500AA
	063600AB 063700AC 06380078 064100A7 06420078 06430071 065A0078 065B0071
	065D0078 065E0083 065F00A7 066008A7 066100A7 066300B2 066408A7 06660083
	06670078 066B00A7 066C0078 066F0071 06710078 067300A8 067400A9 067500AA
	067600AB 067700AC 06780078 068100A7 06820078 06830071 069D0078 069F00A7
	06A10083 06A20078 06A300A7 06A508A7 06A70078 06B00071 06B10078 06B300A8
	06B400A9 06B500AA 06B600AB 06B700AC 06B80078 06C100A7 06C20078 06C30071
	06CC0078 06CD0071 06D90078 06DA0071 06DE0078 06E00071 06E40078 06E50083
	06E60078 06E800A7 06E90083 06EC00A7 06ED08A7 06F00078 06F900A7 06FA0097
	06FB0078 07010071 071A0083 071E0078 07200071 07230081 07240083 072800A8
	072900A9 072A00AA 072B00AB 072C00AC 072D0097 072E0078 07410071 07430078
	07440071 07460078 074A0071 074C0078 074D0071 07500078 07510071 07520078
	07550071 07560078 07570071 075A0083 075D0078 075E0083 075F0078 07600071
	07630081 07640083 07670078 076800A8 076900A9 076A00AA 076B00AB 076C00AC
	076D0078 076E1071 076F0078 07800071 07810094 07820097 07865897 07870097
	078A0094 078C0083 078D0094 079000A8 079100A9 079200AA 079300AB 079400AC
	079500B3 079A0094 079D00B4 079F00A7 07A00071 07A40078 07A50071 07A90871
	07AA0071 07AE0871 07AF0071 07B60078 07B90083 07BB0883 07BD0083 07C40071
	07C60078 07C80083 07CC0078 07CD0083 07D10883 07D20083 07D60883 07D70083
	07DF0094 07E30083 07E40094 07E70078 07E80097 07E90078 08000071 08110078
	08120071 08130871 08140078 08150071 081600A7 08170083 081A0078 081B0083
	081C00A7 081D0078 082000A8 082100A9 082200AA 082300AB 082400AC 08250097
	08280071 082B00A7 082C0083 082D0078 085000B5 08630078 08680071 087E7881
	087F0078 08800071 08AD0078 08B00071 08D20078 08D40071 08FD0078 09000071
	09270078 09280071 092F0078 09300071 09470078 09480071 095B0078 095C0071
	09630078 09640071 098B0078 098C0071 09AE0078 09B00094 09B10097 09B500B6
	09B600B7 09B700B8 09B800B9 09B900B0 09BA00BA 09BB00BB 09BC00BC 09BD00BD
	09BE00BE 09BF0078 09C00071 09C80054 09CD0078 09D00071 09FB0078 0A010071
	0B370097 0B380071 0B3C0078 0B400005 0B410071 0B4E00BF 0B4F0078 0B500071
	0B760097 0B7700C0 0B7800C1 0B790078 0B800071 0B890083 0B8B0078 0B900071
	0B990083 0B9B0097 0B9C0078 0BA00071 0BA90083 0BAA0078 0BB00071 0BB90083
	0BBA0078 0BC00071 0BDA00C2 0BDB00A7 0BDC0083 0BDF00A7 0BE30083 0BE400A7
	0BE50083 0BEA0097 0BEE0071 0BEF0078 0BF000A8 0BF100A9 0BF200AA 0BF300AB
	0BF400AC 0BF50078 0BF800C3 0BF900C4 0BFA00C5 0BFB00C6 0BFC00C7 0BFD0078
	0C000006 0C030099 0C040006 0C060083 0C070005 0C0800A8 0C0900A9 0C0A00AA
	0C0B00AB 0C0C00AC 0C0D0078 0C100071 0C3C0078 0C400071 0C550078 0C800071
	0C8F0078 0C900083 0C9200A7 0C940083 0C9500C8 0C960078 0C9800A7 0C990083
	0C9A00A7 0C9D0083 0C9E0078 0CA00054 0CA10078 0CA20006 0CA300A8 0CA400A9
	0CA500AA 0CA600AB 0CA700AC 0CA80071 0CB70078 0CB80071 0CBB0078 0CC00071
	0CD50078 0CD800A7 0CE10071 0CE400A7 0CE50078 0CE800A8 0CE900A9 0CEA00AA
	0CEB00AB 0CEC00AC 0CED0078 0CEF0006 0CF00054 0D000071 0D0C0083 0D0D00A7
	0D0E0078 0D0F0097 0D100078 0E800055 0E967881 0EA70081 0EA87881 0EB17055
	0EB60055 0EBC7881 0EBD0055 0ECE7881 0EE00083 0EE20078 0F000863 0F4B0855
	0F4D1055 0F4E0078 0F500863 0F7D0078 0F8008C9 0F8408CA 0F8808C9 0F8B0078
	0F8C08CA 0F8F0078 0F9008C9 0F9408CA 0F9808C9 0F9C08CA 0FA008C9 0FA30078
	0FA408CA 0FA70078 0FA80855 0FAC0078 0FB008C9 0FB408CA 0FB808CB 0FB908CC
	0FBB08CD 0FBC08CE 0FBD08CF 0FBE08D0 0FBF0078 0FC008C9 0FC408D1 0FC808C9
	0FCC08D1 0FD008C9 0FD408D1 0FD808C9 0FD90855 0FDC08CA 0FDD08D2 0FDE08D3
	0FDF08D4 0FE01037 0FE10855 0FE408D5 0FE608D3 0FE70837 0FE808C9 0FE90855
	0FEA0078 0FEB0855 0FEC08CA 0FED08D6 0FEE0078 0FEF0837 0FF008C9 0FF10855
	0FF408CA 0FF508D7 0FF608D8 0FF70837 0FF80078 0FF90855 0FFC08D9 0FFD08DA
	0FFE08D3 0FFF1037 10000805 10011005 10060057 100700C2 10080099 100B0006
	100C00DB 100D00B4 100E00DB 100F00B4 10100006 10121006 101400DC 101500DD
	101600DE 101700DF 10180007 101A1007 101B1006 101C0006 101D00E0 101E1006
	10200038 10210006 102200E1 1023000A 10241006 10250006 10290019 102A0038
	102B0006 10300057 10320078 10350057 103878E2 10390078 103A78E3 103B78E4
	103C78E5 103D780B 103E7819 103F780A 104070E2 1041705A 104270E3 104370E4
	104470E5 1045700B 10467019 1047700A 10487081 104B0078 10500008 10541008
	10550008 105B0078 10680083 106F0095 10730083 10760078 10801054 10812877
	10820054 10831054 10840054 10852855 10862877 10872855 10882877 108A0054
	108B1054 108C0054 108D2877 108F0054 10907854 10922877 109308E6 10942877
	109508E7 10962877 10970058 10982877 10990054 109A2855 109B1071 109D0054
	109E2855 109F2877 10A028E8 10A10019 10A32855 10A50054 10A70078 10AA305F
	10B010E9 10B110EA 10B210EB 10B310EC 10B410ED 10B510EE 10B610EF 10B710F0
	10B810F1 10B910F2 10BA10F3 10BB10F4 10BC10F5 10BD10F6 10BE10F7 10BF10F8
	10C000F9 10C100FA 10C20078 10C80019 10CB0054 10CD0819 10CE0054 10D00019
	10D10054 10D30019 10D40054 10D70819 10D80054 10E70819 10E80054 10E90019
	10EB0054 10FA0019 110100E8 110208E8 11030019 110400FB 110608FC 11070019
	1109000B 110A0019 110B00E8 110C0019 110D00E8 110F0019 111000E8 111208E8
	11140019 111610E8 111700E8 111810E8 111900E8 111A0019 111E00FD 111F00E8
	112208E8 112300E8 11270019 112900FD 112B0019 113008E8 113200FD 11360019
	113708FD 113900FD 113A08FD 113B00FD 113C08FD 113D00FD 114008FD 114100FD
	114208FD 114300FD 114408FD 114500FD 114600E8 11470019 114800FE 114A0019
	114C00FF 114D0019 115100FD 11520019 11530100 11540101 115500E8 115608E8
	115800FD 115C00E8 115D0019 115F00E8 11600019 116500FE 11670019 116800FD
	11690019 116B00FD 117008FD 117200FD 117508FD 11770019 117800FD 11790102
	117B0103 117C00E8 117D0104 117F0105 11800054 118400FD 11860054 119000E8
	11910054 1195080A 11960054 119B0094 11BE0019 11BF0054 11CE0019 11DA00B4
	11DB0006 11DC0054 11EE0078 12000054 12140078 12200054 12260078 12301906
	12311907 12321908 12331909 1234190A 1235190B 1236190C 1237190D 1238190E
	1239190F 123A1106 123B1107 123C1108 123D1109 123E110A 123F110B 1240110C
	1241110D 1242110E 1243110F 1244105D 1245105B 12461110 12471111 12481112
	12491113 124A1114 124B1115 124C1116 124D1117 124E1094 125B1918 12681919
	127518C3 1276011A 1277011B 1278011C 1279011D 127A011E 127B00C4 127C00C5
	127D00C6 127E00C7 127F011F 12800054 12FC0019 13000054 134F0078 13500054
	13560094 13570054 13590078 13810054 13850078 13860054 13940078 13950054
	13A60078 13A80054 13AA0078 13AB0054 13B00078 13B10054 13B40009 13BB0106
	13BC0107 13BD0108 13BE0109 13BF010A 13C00106 13C10107 13C20108 13C30109
	13C4010A 13C50106 13C60107 13C70108 13C80109 13C9010A 13CA0054 13CB0078
	13CC0054 13D80078 13D90054 13E000E8 13E10019 13E200FE 13E3000A 13E40078
	13E80019 13EA00E8 13EB00FE 13EC0019 13EE00E8 13EF00FE 13F00019 13F100FD
	13F30009 13F60078 13F80019 14000094 14800019 14C2000A 14C70120 14C80121
	14C9000A 14CD0019 14CE00E8 14D80019 14DC0122 14DD0019 14E000FD 14E100E8
	14E200FD 14E30019 14E700E8 14E800FE 14EA00FD 14EB0019 14EC0009 14EE00E8
	14EF0019 14F200E8 14F30019 14F400E8 14F50019 14FA00E8 14FC00FD 14FD0019
	14FE0009 14FF0019 150500E8 150610E8 150700E8 15110019 151200E8 15140019
	151600FE 15180019 151A00FD 151B0019 151E00FD 151F00E8 15200019 152C00E8
	152D0019 153200FD 15330019 153500E8 15370019 153800E8 15390019 153A10E8
	153B1019 153C0019 153D00FE 153E00E8 153F00FE 154300E8 154600FE 154700E8
	154900FE 154F00E8 155100FE 15520019 155300FD 15570019 155800FE 155900E8
	155A00FE 155B00E8 155E00FE 156400E8 156700FE 156C0019 156E08E8 156F0123
	15700019 157100E8 15720124 157300E8 15740019 157600FD 157700E8 15780019
	157C00FE 157E0019 15800054 158A0078 16000096 16180098 16300078 16400063
	16720055 16730054 16760078 167D0006 16800125 16930078 16980071 16B30078
	16C00071 16CC0078 16D00071 16F00078 17000006 17010126 17030006 170500E0
	17060126 17070006 170C0078 170E0126 170F0078 17400054 174D0078 174E0054
	177A0078 17801054 17EB0078 17F80054 17FE0078 18008805 18010006 18020054
	18030071 18040009 18090054 180A0009 180E0099 180F00BF 18100054 18110127
	18120128 18130129 1814012A 18150083 18180099 18190081 181B1054 181C112B
	181D112C 181E0071 181F0054 18200078 18210071 18260871 18320071 18380871
	18390071 183A0871 183C0071 183D0871 183F0071 184A0871 184B0071 184C0078
	184D0083 184E1037 184F0881 18500099 18510071 18560871 18620071 18680871
	18690071 186A0871 186C0071 186D0871 186F0071 187A0871 187B0071 187C0871
	187E0081 187F0881 18800078 18830071 18970078 18991071 18C80094 18C978AD
	18CA78AE 18CB7894 18D00071 18DC0078 18E00054 18E80078 18F80071 19001094
	190F1054 191010AD 191110AE 1912112D 1913112E 1914112F 19151094 19220078
	19286854 19291930 192A1931 192B1932 192C1933 192D1934 192E1935 192F1936
	19301894 193E1854 194018AD 194118AE 1942192D 1943192E 1944192F 19451894
	19591937 195A1938 195B1939 195C193A 195D193B 195E193C 195F193D 19601094
	19666854 19681894 19806894 19AC1094 19B96894 19BC6854 19BE6894 19EF6854
	19F01094 1A000071 26DB0078 26E00054 27000071 4FDE0078 50000071 52470078
	52480054 52640078 53800037 538C0078 54000071 540100C8 54020071 54030083
	54040071 541200A7 54130083 54140054 54160078 56000071 6BD20078 6C00013E
	7000013F 7C800871 7D070071 7D080871 7D0A0071 7D0B0871 7D120071 7D130871
	7D140071 7D150871 7D170078 7D180871 7D360078 7D380871 7D6D0078 7D801055
	7D840078 7D8A1055 7D8C0078 7D8F0083 7D90289B 7D95089B 7DA10078 7DA2089B
	7DA8409E 7DAA389E 7DAB409E 7DAC389E 7DAD409E 7DAE389E 7DAF409E 7DB0389E
	7DB1409E 7DB2389E 7DB3409E 7DB4389E 7DB5409E 7DB6389E 7DB7409E 7DB8389E
	7DB9409E 7DBA389E 7DBB409E 7DBC389E 7DBD409E 7DBE389E 7DBF409E 7DC0389E
	7DC1409E 7DC8389E 7DC9409E 7DCA389E 7DCB409E 7DCC389E 7DCD409E 7DCE389E
	7DCF409E 7DD1389E 7DD2409E 7DD4389E 7DD5409E 7DD6389E 7DD7409E 7DD90078
	7DEA209E 7DEB489E 7DEC209E 7DEF409E 7DF3389E 7DF5409E 7DFC389E 7DFD209E
	7DFE409E 7DFF389E 7E00409E 7E32209E 7E4C389E 7E70489E 7E7B409E 7E89209E
	7E97389E 7E9A489E 7E9E209E 7E9F00B4 7EA00078 7EA8389E 7EAC209E 7EAE389E
	7EAF209E 7EB0389E 7EB1209E 7EB4389E 7EB5209E 7EB8389E 7EBA209E 7EC3389E
	7EC80078 7EC9389E 7ECB209E 7ECC389E 7ECD209E 7EDA389E 7EDB209E 7EDC389E
	7EDE209E 7EE2389E 7EE3209E 7EE40078 7EF8409E 7EFE4140 7EFF0078 7F000083
	7F088006 7F0C80BF 7F0D0078 7F100083 7F120078 7F188006 7F198099 7F1A8038
	7F1B80BF 7F230006 7F2480BF 7F251006 7F271038 7F28600C 7F2A6006 7F2C6099
	7F2D60BF 7F306006 7F31600B 7F326019 7F346006 7F356007 7F360078 7F38409E
	7F41209E 7F46489E 7F47209E 7F49489E 7F4A209E 7F4C489E 7F4D209E 7F4E489E
	7F4F209E 7F50489E 7F51209E 7F52489E 7F53209E 7F54489E 7F55209E 7F5A489E
	7F5B209E 7F5C489E 7F5D209E 7F5E489E 7F5F209E 7F60489E 7F61209E 7F62489E
	7F63209E 7F64489E 7F65209E 7F66489E 7F67209E 7F68489E 7F69209E 7F6A489E
	7F6B209E 7F6C489E 7F6D209E 7F6E489E 7F6F209E 7F70489E 7F71209E 7F72489E
	7F73209E 7F74489E 7F75209E 7F76489E 7F77209E 7F7A489E 7F7B209E 7F7F0078
	7F818806 7F828808 7F838806 7F848809 7F858806 7F86880C 7F88880E 7F898810
	7F8A8812 7F8B8814 7F8C8816 7F8D880C 7F8E8818 7F8F881A 7F908806 7F918860
	7F9E8806 7F9F8837 7FA18861 7FAE8819 7FB0880A 7FB15009 7FB25006 7FB35071
	7FB85081 7FB95071 7FCF5081 7FD05071 7FE00078 7FE15071 7FE40078 7FE55071
	7FE80078 7FE95071 7FEC0078 7FED5071 7FEF0078 7FF08808 7FF18819 7FF28854
	7FF38808 7FF45054 7FF55019 7FF75054 7FF80078 7FFD0141 7FFE0054 7FFF0078
	80000071 80060078 80070071 801F0078 80200071 80270078 80280071 802F0078
	80400071 807E0078 80800097 80810094 80820078 808400B6 808500B7 808600B8
	808700B9 808800B0 808900BA 808A00BB 808B00BC 808C00BD 808D0142 808E0143
	808F0144 80900145 809100B1 80920146 80930147 80940148 80950149 8096014A
	8097014B 8098014C 8099014D 809A0078 809C0094 80A0014E 80A1014F 80A20150
	80A30151 80A40152 80A50150 80A60153 80A70151 80A80154 80A90155 80AA0156
	80AB0157 80AC014F 80AE0158 80B00154 80B30150 80B50155 80B60153 80B90151
	80BA0150 80BB005F 80BD0054 80C500C3 80C60078 81800071 819000AD 819100B0
	81920078 81980071 81A50159 81A60078 81C00071 81CF0078 81D00071 81E20078
	81E40071 81E80094 81E90158 81EA015A 81EB0078 8200015B 8214015C 82280071
	824F0078 825000A8 825100A9 825200AA 825300AB 825400AC 82550078 8400009B
	84030078 8404009B 841B0078 841C009B 841D0078 841E009B 841F0078 8500009B
	85010083 85020078 85030083 85040078 85060083 8508009B 850A0078 850B009B
	850C0078 850D009B 851A0078 851C0083 851E0078 8520015D 8521015E 8522015F
	85230160 85240078 8528009A 852D0078 E8000094 E87B0078 E8800094 E8940078
	E8950094 E8AF0894 E8B300A7 E8B40083 E8B50094 E8B700A7 E8BA0057 E8BE0083
	E8C20094 E8C30083 E8C60094 E8D50083 E8D70094 E8DE0894 E8E10094 E8EF0078
	E9000054 E9210083 E9230078 E9800054 E9AC0078 EA002877 EA0D2855 EA1A2877
	EA272855 EA342877 EA412855 EA4E2877 EA500078 EA512877 EA520078 EA532877
	EA540078 EA552877 EA5B2855 EA5D0078 EA5F2855 EA620078 EA632855 EA682877
	EA752855 EA822877 EA830078 EA842877 EA860078 EA872877 EA8F2855 EA9C2877
	EA9D0078 EA9E2877 EAA40078 EAA52877 EAA92855 EAB62877 EAC32855 EAD02877
	EADD2855 EAEA2877 EAF72855 EB042877 EB112855 EB1E2877 EB2B2855 EB382877
	EB452855 EB530078 EB542877 EB612855 EB712877 EB7E2855 EB8E2877 EB9B2855
	EBAB2877 EBB82855 EBC82877 EBD52855 EBE50078 EBE7280E EBE82810 EBE92812
	EBEA2814 EBEB2816 EBEC280E EBED2810 EBEE2812 EBEF2814 EBF02816 EBF1280E
	EBF22810 EBF32812 EBF42814 EBF52816 EBF6280E EBF72810 EBF82812 EBF92814
	EBFA2816 EBFB280E EBFC2810 EBFD2812 EBFE2814 EBFF2816 EC000078
"

constant a1 = U"00000071 536C0078 7C000871 7D0F0078"

constant a7 = U"00100057 00400078 00800083 00F80078 8000013F FFFF0078"

constant a8 = U"0000013F 7FFF0078"

constant a16 = U"
	00800865 00880065 00890865 00930065 00940865 00980161 00991065 009A0865
	009C0863 009F1063 00A00063 00A10863 00A41055 00A50065 00A60865 00A90065
	00AA0865 00B30065 00B40865 00BC0863 00BF1162 00C00163 00C10065 00C30063
	00C40068 00C50063 00C60055 00C70164 00C80063 00C90068 00CA0165 00CB0166
	00CC0065 00CD0055 00CE0167 00CF0168 00D00865 00D10065 00D30063 00D4006F
	00D50055 00D60065 00D70863 00D80070 00D90063 00DB0169 00DC0065 00DD0071
	00DE0065 00DF016A 00E00071 00E21074 00E31072 00E41073 00E51074 00E60863
	00EE016B 00EF0865 00F20065 00F30865 00F81072 00F91073 00FA0865 00FB016C
	00FC0865 010E0065 010F0865 01100055 01110065 01130865 011A0055 011D0063
	011E016D 011F0055 0120016E 01210078 01280055 0129016F 012A0055 012B007A
	012C0170 012D0171 012E0055 01310172 01320055 01340173 01350055 01370173
	01380055 013A0174 013B0055 0141007D 01420055 0145007E 01460055 01587881
	015C0082 015D0081 01610037 01630082 01680081 01690037 016C1037 016F0037
	01707881 01720037 01800083 01A00883 01A20175 01A30083 01B80078 01BA0037
	01BB0078 01C20837 01C30806 01C40885 01C50078 01C70887 01C80060 01D50860
	01D60889 01D80061 01E50861 01E6088C 01E70078 01E81176 01E90877 01EA1177
	01EB0055 01EC0065 01F81093 01F90055 01FA1178 01FB0063 01FC10D8 01FD0065
	01FE0077 02000892 02020092 02030892 02040092 02060892 02070092 02080060
	020C0860 020D0060 02180061 021C0861 021D0061 02280893 022A0093 022B0893
	022C0093 022E0893 022F0093 02300065 023B0865 023C0065 02410083 02430078
	02440095 02450065 02600863 02610063 02670078 02680865 026A0065 026B0865
	026C0065 026D0865 02700065 02710865 02740065 02750865 027B0065 027C0865
	027D0078 02800065 02880078 02980096 02AB0078 02AC0081 02AD0097 02B00098
	02C31055 02C40097 02C50078 02C80083 02E1009A 02E20083 02E40078 02E8009B
	02F50078 02F8009B 02F9009A 02FA0078 0300009C 03020078 03050140 0306009D
	03070054 03080083 030B0078 030D009D 030E0078 030F009D 0310009E 0311089E
	0313009E 031D0078 0320009E 03250083 032F0078 03300179 0331017A 0332017B
	0333017C 0334017D 033500A5 0336009D 0337009E 033A109E 033C009E 0369089E
	036A009E 036B0083 036E009C 036F0083 0372009F 03730083 03740054 03750083
	0377009E 0378000F 03790011 037A0013 037B0015 037C0017 037D009E 037E00A6
	037F009E 0380009D 03870057 03880083 0389009E 03980083 03A50078 03A6009E
	03B70078 03C0009E 03D30083 03D8009E 03D90078 04800083 048100A7 04820071
	04940871 04950071 04980871 04990071 049D0078 049E0071 049F00A7 04A00083
	04A400A7 04A60083 04A70078 04A80083 04AA0078 04AC0871 04B00071 04B10083
	04B20097 04B3017E 04B4017F 04B50180 04B60181 04B70182 04B80078 04BE0071
	04BF0078 04C00083 04C100A7 04C20071 04C60078 04C70071 04C80078 04C90071
	04D40078 04D50071 04D80078 04DB0071 04DD0078 04DE0071 04DF00A7 04E00083
	04E20078 04E300A7 04E40078 04E508A7 04E60083 04E70078 04EB00A7 04EC0078
	04EE0871 04F00071 04F10083 04F20078 04F3017E 04F4017F 04F50180 04F60181
	04F70182 04F80071 04F90008 04FA00B6 04FB00B7 04FC0183 04FD0078 05000083
	050100A7 05020071 05050078 05070071 05080078 05090071 05140078 05150071
	05180078 05190871 051A0071 051B0078 051C0071 051D0078 051F00A7 05200083
	05210078 05230083 05240078 05250083 05270078 052C0871 052E0078 0533017E
	0534017F 05350180 05360181 05370182 05380083 05390071 053A0078 05400083
	054100A7 05420071 05540078 05550071 05580078 05590071 055D0078 055E0071
	055F00A7 05600083 056400A7 05660083 05670078 05700071 05710083 05720078
	0573017E 0574017F 05750180 05760181 05770182 05780008 05790078 05800083
	058100A7 05820071 05860078 05870071 05880078 05890071 05940078 05950071
	05980078 05990071 059D0078 059E0071 059F0083 05A20078 05A300A7 05A40078
	05A508A7 05A60083 05A70078 05AB00A7 05AC0078 05AE0871 05AF0071 05B10078
	05B3017E 05B4017F 05B50180 05B60181 05B70182 05B80071 05B90078 05C10071
	05C50078 05C70071 05C80078 05C90071 05CB0078 05CC0071 05CD0078 05CF0071
	05D00078 05D10071 05D20078 05D40071 05D50078 05D70071 05DD0078 05DF00A7
	05E10078 05E300A7 05E40078 05E508A7 05E60083 05E70078 05EB00A7 05EC0078
	05F3017E 05F4017F 05F50180 05F60181 05F70182 05F80184 05F90054 05FC0008
	05FD0078 060000A7 06020071 06060078 06070071 06080078 06090071 06140078
	06150071 061D0078 061F0083 062000A7 06220078 06230083 06240078 06250083
	06270078 062A0083 062B0078 06300071 06310078 0633017E 0634017F 06350180
	06360181 06370182 06380078 064100A7 06420071 06460078 06470071 06480078
	06490071 06540078 06550071 065D0078 065E0071 065F00B2 066000A7 06620078
	066308A7 06640078 066508A7 06660083 06670078 066A00A7 066B0078 06700071
	06710078 0673017E 0674017F 06750180 06760181 06770182 06780078 068100A7
	06820071 06860078 06870071 06880078 06890071 06940078 06950071 069D0078
	069F00A7 06A00083 06A20078 06A300A7 06A40078 06A508A7 06A60083 06A70078
	06AB00A7 06AC0078 06B00071 06B10078 06B3017E 06B4017F 06B50180 06B60181
	06B70182 06B80078 06C100A7 06C20071 06CB0078 06CD0071 06DF0078 06E00071
	06E30078 06E700A7 06E90083 06EA0078 06EC00A7 06EE08A7 06EF00A7 06F00078
	06F900A7 06FA0078 07000071 07180083 07191071 071A0083 071D0078 071F0008
	07200071 07230083 07270097 0728017E 0729017F 072A0180 072B0181 072C0182
	072D0097 072E0078 07400071 07410078 07430071 07440078 07460071 07470078
	074A0071 07540078 07550071 07580083 07591071 075A0083 075E0071 075F0078
	07600071 07620078 07640083 07670078 0768017E 0769017F 076A0180 076B0181
	076C0182 076D0078 076E1071 076F0078 07800094 07820097 07890094 078C0083
	078D0094 0790017E 0791017F 07920180 07930181 07940182 079500B3 079A0083
	079D00BF 079F00A7 07A00071 07A10871 07A20071 07A60871 07A70071 07AB0871
	07AC0071 07B40871 07B50078 07B80083 07B90883 07BB1083 07BD0083 07BF00A7
	07C00883 07C10083 07C20097 07C30083 07C40071 07C60078 07C80083 07C90883
	07CA0083 07CE0883 07CF0083 07D30883 07D40083 07DC0883 07DD0083 07DE0078
	07DF0094 07E60078 07E70094 07E80097 07E90078 08000071 08150078 08160083
	081800A7 08190078 081B0083 081D0078 0820017E 0821017F 08220180 08230181
	08240182 08250097 08280071 082B00A7 082C0083 082D0078 085000B5 08630078
	08680071 087D0097 087E0078 08800071 08AD0078 08AF0071 08D10078 08D40071
	08FD0078 09000071 09240078 09250071 09270078 09280071 092B0078 092D0071
	092F0078 09300071 09440078 09450071 09470078 09480071 09580078 09590071
	095B0078 095C0071 095F0078 09610071 09630078 09640071 096B0078 096C0071
	09880078 09890071 098B0078 098C0071 09AD0078 09AF0083 09B00097 09B400AD
	09B500AE 09B6012D 09B7012E 09B8012F 09B90185 09BA0186 09BB0187 09BC0188
	09BD0184 09BE0078 09C00071 09C80054 09CD0078 09D00071 09FA0078 0A000071
	0B360097 0B370071 0B3B0078 0B400071 0B4D00B4 0B4E0078 0B500071 0B750097
	0B770189 0B780078 0B800071 0B860078 0B870071 0B890083 0B8A0078 0B900071
	0B990083 0B9A0097 0B9B0078 0BA00071 0BA90083 0BAA0078 0BB00071 0BB60078
	0BB70071 0BB80078 0BB90083 0BBA0078 0BC00071 0BDA00C2 0BDB0083 0BDF00A7
	0BE40083 0BEA0097 0BEB0081 0BEC0097 0BED0008 0BEE0083 0BEF0078 0BF0017E
	0BF1017F 0BF20180 0BF30181 0BF40182 0BF50078 0BF80106 0BF90107 0BFA0108
	0BFB0109 0BFC010A 0BFD0078 0C000006 0C050083 0C070078 0C08017E 0C09017F
	0C0A0180 0C0B0181 0C0C0182 0C0D0078 0C100071 0C210081 0C220071 0C3C0078
	0C400071 0C540083 0C550078 0C800071 0C8E0078 0C900083 0C9100A7 0C930083
	0C9400C8 0C960078 0C9800A7 0C9C0083 0C9E0078 0CA20006 0CA3017E 0CA4017F
	0CA50180 0CA60181 0CA70182 0CA80071 0CB70078 0CB80071 0CBA0078 0CC00071
	0CD50078 0CD800A7 0CE00071 0CE400A7 0CE50078 0CE8017E 0CE9017F 0CEA0180
	0CEB0181 0CEC0182 0CED0078 0CEF0006 0CF00054 0D000071 0D0B0083 0D0C00A7
	0D0E0078 0D0F0097 0D100078 0E800055 0E967881 0E970081 0E987881 0E9D0081
	0E9E7881 0EB17055 0EB50055 0ECD7881 0EE00083 0EE20078 0F000865 0F4B0855
	0F4D098A 0F4E0078 0F500865 0F7D0078 0F8008C9 0F8408CA 0F8808C9 0F8B0078
	0F8C08CA 0F8F0078 0F9008C9 0F9408CA 0F9808C9 0F9C08CA 0FA008C9 0FA30078
	0FA408CA 0FA70078 0FA808C9 0FAC08CA 0FB008C9 0FB408CA 0FB808CB 0FB908CC
	0FBB08CD 0FBC08CE 0FBD08CF 0FBE08D0 0FBF0078 0FC008C9 0FC408D1 0FC808C9
	0FCC08D1 0FD008C9 0FD408D1 0FD808C9 0FD9098B 0FDA0078 0FDB0855 0FDC08CA
	0FDD08D2 0FDE1037 0FE00837 0FE1098B 0FE20078 0FE30855 0FE408D5 0FE60837
	0FE808C9 0FE90855 0FEA0078 0FEB0855 0FEC08CA 0FED08D6 0FEE0837 0FF008C9
	0FF10855 0FF20890 0FF30855 0FF408CA 0FF508D7 0FF60837 0FF80078 0FF9098B
	0FFA0078 0FFB0855 0FFC08D9 0FFD08DA 0FFE0837 0FFF0078 10000805 10011005
	10035805 10041005 10050057 1007018C 10085899 10090099 100B1006 100C018D
	100D00DB 100E018D 100F00DB 10100006 10121006 10130006 1014018E 1015018F
	10160190 10175853 10180007 10191007 101A0006 101B1006 101C0126 101D0006
	101F0038 10200006 10220009 10231006 10250006 102B1006 102C0006 102F1005
	10300057 10320078 10350057 10387855 10390078 103A7910 103B7911 103C7912
	103D780B 103E7809 103F7855 1040705D 1041705B 10427110 10437111 10447112
	1045700B 10467009 10470078 10487081 104A0078 10500008 105B0078 10680083
	106E0095 10700083 10710095 10720083 10760078 10801054 10831077 10841054
	10852877 10872855 10882877 10892855 108A2877 108B0054 108C2877 108F0054
	10901054 10910054 10950991 10962877 10972855 10982877 109A1071 109C2855
	109D1054 109E2855 109F2877 10A00019 10A22877 10A32855 10A50019 10A60078
	10A9305F 10AF3106 10B01192 10B11193 10B21194 10B31195 10B41196 10B51197
	10B61198 10B71199 10B8119A 10B9119B 10BA119C 10BB119D 10BC119E 10BD119F
	10BE11A0 10BF11A1 10C001A2 10C101A3 10C20078 10C80019 10CA0054 10CD0819
	10CE0054 10D10019 10D20054 10E60854 10E70819 10E80054 10FA0019 110000E8
	11020019 110408FB 110500FC 11070019 110800E8 11090059 110A01A4 110B0019
	110D00E8 11110019 111500E8 111610E8 111800E8 111A0019 111C00E8 111E00FE
	111F00E8 112008E8 112101A5 112200E8 112308E8 112500E8 11260019 112900FE
	112B0019 112F00E8 11300019 113200FE 11360819 113708FE 113900FE 113A08FE
	113B00FE 113C08FE 113D00FE 114008FE 114100FE 114208FE 114300FE 114408FE
	114500FE 11460019 114700FD 11490019 115100FE 11520019 115300E8 115401A6
	115608E8 115800FE 115C0019 115F00E8 11600019 116400FD 116601A7 11670019
	116800FE 11690019 116B00FE 117008FE 117200FE 117508FE 11770019 117800FE
	11790102 117A00E8 117B0103 117C00E8 117D0104 117E0105 117F00E8 11800054
	118400FE 11860054 119000E8 11910054 11940809 11950054 119B0094 11BD0054
	11CA0094 11CB0054 11CD0019 11DA00BF 11DB0054 11EE0078 12000054 12130078
	12200054 12250078 123018C4 123118C5 123218C6 123318C7 1234191F 1235191A
	1236191B 1237191C 1238191D 1239191E 123A10C4 123B10C5 123C10C6 123D10C7
	123E111F 123F111A 1240111B 1241111C 1242111D 1243111E 1244105A 124510E3
	124610E4 124710E5 124811A8 124911A9 124A11AA 124B11AB 124C11AC 124D11AD
	124E1094 125B1918 12681919 1275010B 1276010C 1277010D 1278010E 1279010F
	127A0106 127B0107 127C0108 127D0109 127E010A 127F00C3 12800054 12DB0019
	12DC0054 12E00019 12E10054 12FC0019 13000054 13370019 13380054 134E0078
	13500054 13590078 13800054 13820078 13830054 13850078 13860054 13A90078
	13AC0054 13AF0078 13B00054 13B4000A 13BB00C4 13BC00C5 13BD00C6 13BE00C7
	13BF011F 13C000C4 13C100C5 13C200C6 13C300C7 13C4011F 13C500C4 13C600C5
	13C700C6 13C800C7 13C9011F 13CA0078 13CC0054 13DF0078 13E00019 13E100FD
	13E20009 13E30078 13E80019 13E900E8 13EA00FD 13EB0019 13EE00FD 13EF0019
	13F100FE 13F3000A 13F60078 13F80019 14000094 14800019 14C10009 14C601AE
	14C701AF 14C80009 14CC0019 14CD00E8 14D80019 14E000FE 14E100E8 14E200FE
	14E30019 14E400E8 14E50019 14E700FD 14E90019 14EA00FE 14EB0019 14EC000A
	14EE0019 14F000E8 14F30019 14F400E8 14F50019 14FA01B0 14FB00E8 14FC00FE
	14FD0019 14FE000A 14FF0019 150500E8 150E0019 150F00E8 15110019 151400E8
	151500FD 15170019 151A00FE 151B0019 151E00FE 151F0019 152B00E8 152C0019
	153200FE 15330019 153500E8 15380019 153900E8 153A1019 153B0019 153C00FD
	153D00E8 153E00FD 154200E8 154500FD 154600E8 154800FD 154E00E8 155000FD
	155100E8 15520019 155300FE 155700FD 155800E8 155900FD 155A00E8 155D00FD
	156300E8 156600FD 156B0019 157101B1 15730019 157600FE 15770019 157900E8
	157A0019 157B00FD 157D00E8 157F0019 15800054 158A0078 16000096 16170078
	16180098 162F0078 16400065 16720054 16750078 167C0006 167E005F 167F0006
	16800125 16930078 16980071 16B30078 16B77881 16B80078 16C00071 16CB0078
	16D00071 16D30078 16D40071 16D70078 16D80071 16DB0078 16DC0071 16DF0078
	16E00071 16E30078 16E40071 16E70078 16E80071 16EB0078 16EC0071 16EF0078
	17000006 170100E0 17030006 17040126 17050006 170600E0 17070006 170B0099
	170C0078 170E00E0 170F0078 17400054 174F1054 17500054 17791054 177A0078
	17801054 17EB0078 17F80054 17FE0078 18000006 18020081 180301B2 1804000A
	18090054 180A000A 180E00B4 180F00BF 181001B3 181101B4 181201B5 181301B6
	181401B7 18150083 18180081 181B0054 181C11B8 181D0081 181E0006 181F0054
	18200071 18320871 18350071 18380871 183A0071 183B0871 183D0071 183E0871
	183F0071 184B0078 184C0083 184D1037 184E0081 184F8071 18500071 18620871
	18650071 18680871 186A0071 186B0871 186D0071 186E0871 186F0071 187B0871
	187D0006 187E0081 187F8071 18800078 18820071 18960078 18981071 18C70078
	18C80094 18C978B6 18CA78B7 18CB7894 18D00071 18DC0078 18E00054 18E80078
	18F80071 19001094 190E1054 190F0078 191010B6 191110B7 191210B8 191310B9
	191410B0 19151094 19220078 192819B9 192919BA 192A19BB 192B19BC 192C19BD
	192D19BE 192E19BF 192F19C0 19301894 193E1854 193F0094 194018B6 194118B7
	194218B8 194318B9 194418B0 19451894 195819C1 195919C2 195A19C3 195B19C4
	195C19C5 195D19C6 195E19C7 195F19C8 19601094 19666854 19681894 197F0078
	19806894 19AC1094 19B86894 19BB6854 19BD6894 19EF6854 19F01094 19FF6854
	1A000071 26DB0078 26E00054 27000071 4FDE0078 50000071 500A0081 500B0071
	52460078 52480054 52630078 53800037 538B0078 54000071 54050083 54060071
	541100A7 54120083 541300A7 54140054 54160078 56000071 6BD20078 6C00013E
	7000013F 7C800871 7D070071 7D0A0871 7D0F0071 7D120871 7D130071 7D150871
	7D170078 7D180871 7D350078 7D380871 7D6D0078 7D801055 7D830078 7D891055
	7D8C0078 7D8E089B 7D90289B 7D94280B 7D95089B 7D9B0078 7D9C089B 7D9E0078
	7DA0089B 7DA20078 7DA3089B 7DA7109B 7DA8209E 7DAA489E 7DAB209E 7DAC489E
	7DAD209E 7DAE489E 7DAF209E 7DB0489E 7DB1209E 7DB2489E 7DB3209E 7DB4489E
	7DB5209E 7DB6489E 7DB7209E 7DB8489E 7DB9209E 7DBA489E 7DBB209E 7DBC489E
	7DBD209E 7DBE489E 7DBF209E 7DC0489E 7DC1209E 7DC8489E 7DC9209E 7DCA489E
	7DCB209E 7DCC489E 7DCD209E 7DCE489E 7DCF209E 7DD1489E 7DD2209E 7DD4489E
	7DD5209E 7DD6489E 7DD7209E 7DD90078 7DE9409E 7DEA389E 7DEB409E 7DEF209E
	7DF3489E 7DF5209E 7DFC409E 7DFD389E 7DFE209E 7DFF489E 7E00409E 7E32209E
	7E4B389E 7E6F489E 7E7A409E 7E88209E 7E96389E 7E9A489E 7E9E409E 7E9F00BF
	7EA00078 7EA8209E 7EA9389E 7EAD209E 7EAE389E 7EAF209E 7EB0389E 7EB3209E
	7EB5389E 7EB7209E 7EB9389E 7EBA209E 7EBB389E 7EBC209E 7EBE389E 7EBF209E
	7EC1389E 7EC2209E 7EC4389E 7EC5209E 7EC6389E 7EC80078 7EC9389E 7ECB209E
	7ECE389E 7ECF209E 7EDA389E 7EDB209E 7EE1389E 7EE3209E 7EE40078 7EF8409E
	7EFE0054 7EFF0078 7F000083 7F088006 7F0B80B4 7F0C8006 7F0D0078 7F100083
	7F120078 7F188099 7F198038 7F1A80B4 7F220006 7F2380B4 7F241006 7F261038
	7F286006 7F290078 7F2A600C 7F2B6006 7F2C60B4 7F2F6007 7F306006 7F31600D
	7F326019 7F330078 7F346008 7F356006 7F360078 7F38489E 7F39009E 7F3A0078
	7F3B489E 7F40409E 7F45389E 7F46409E 7F48389E 7F49409E 7F4B389E 7F4C409E
	7F4D389E 7F4E409E 7F4F389E 7F50409E 7F51389E 7F52409E 7F53389E 7F54409E
	7F59389E 7F5A409E 7F5B389E 7F5C409E 7F5D389E 7F5E409E 7F5F389E 7F60409E
	7F61389E 7F62409E 7F63389E 7F64409E 7F65389E 7F66409E 7F67389E 7F68409E
	7F69389E 7F6A409E 7F6B389E 7F6C409E 7F6D389E 7F6E409E 7F6F389E 7F70409E
	7F71389E 7F72409E 7F73389E 7F74409E 7F75389E 7F76409E 7F79389E 7F7A409E
	7F7E0078 7F7F0057 7F808806 7F818807 7F838806 7F84880A 7F85880B 7F86880D
	7F87880C 7F88880F 7F898811 7F8A8813 7F8B8815 7F8C8817 7F8D8806 7F8E8819
	7F8F8806 7F908860 7F9D8835 7F9E8836 7F9F8838 7FA08861 7FAD8835 7FAE8836
	7FAF8809 7FB05006 7FB1500A 7FB25006 7FB35071 7FCF5081 7FD05071 7FDF0078
	7FE15071 7FE40078 7FE55071 7FE80078 7FE95071 7FEC0078 7FED5071 7FEE0078
	7FF08808 7FF18837 7FF28808 7FF30078 7FF45019 7FF65054 7FF70078 7FFC0141
	7FFE0054 7FFF0078 80000071 80130078 80140071 801D0078 801E0071 80270078
	80280071 802F0078 80400071 807D0078 80800006 80810078 808300AD 808400AE
	8085012D 8086012E 8087012F 80880185 80890186 808A0187 808B0188 808C0184
	808D01C9 808E01CA 808F01CB 809001CC 809101CD 809201CE 809301CF 809401D0
	809500BE 809601D1 809701D2 809801D3 809901D4 809A0078 809B0094 80A0014E
	80A10152 80A20153 80A30157 80A40154 80A50155 80A60156 80A70152 80A80150
	80A90153 80AA01D5 80AB0154 80AC014F 80AD0158 80AF0152 80B00154 80B201D6
	80B30150 80B501D7 80B60153 80B80156 80B90152 80BA005F 80BC0054 80C50078
	81800071 818F0078 8190012D 819100BB 81920078 81980071 81A50078 81C00071
	81CF0097 81D00071 81E20078 81E40071 81E8014F 81E90154 81EA0155 81EB0078
	8200015B 8214015C 82280071 824F0078 8250017E 8251017F 82520180 82530181
	82540182 82550078 8400009B 84030078 8405009B 841C0078 841F009B 84200078
	85000083 85030078 85060083 8508009B 851A0078 851C0083 851D0078 851F0083
	852001D8 852101D9 852201DA 852301DB 85240078 8528009A 852C0078 E8000094
	E87B0078 E8800094 E8930078 E8950094 E8AF0894 E8B200A7 E8B30083 E8B50094
	E8B600A7 E8B90057 E8BD0083 E8C10094 E8C20083 E8C60094 E8D50083 E8D70094
	E8DD0894 E8E00094 E8EF0078 E9000054 E9210083 E9220054 E9230078 E9800054
	E9AB0078 EA002877 EA0D2855 EA1A2877 EA272855 EA2A0078 EA2B2855 EA342877
	EA412855 EA4E0078 EA4F2877 EA500078 EA522877 EA530078 EA542877 EA560078
	EA572877 EA5B2855 EA682877 EA752855 EA822877 EA850078 EA862877 EA8A0078
	EA8B2877 EA8E0078 EA8F2855 EA9C2877 EA9F0078 EAA02877 EAA20078 EAA52877
	EAA80078 EAA92855 EAB62877 EAC32855 EAD02877 EADD2855 EAEA2877 EAF72855
	EB042877 EB112855 EB1E2877 EB2B2855 EB382877 EB452855 EB530078 EB542877
	EB6029DC EB612855 EB6D29DC EB6E2855 EB712877 EB7D29DC EB7E2855 EB8A29DC
	EB8B2855 EB8E2877 EB9A29DC EB9B2855 EBA729DC EBA82855 EBAB2877 EBB729DC
	EBB82855 EBC429DC EBC52855 EBC82877 EBD429DC EBD52855 EBE129DC EBE22855
	EBE50078 EBE7280F EBE82811 EBE92813 EBEA2815 EBEB2817 EBEC280F EBED2811
	EBEE2813 EBEF2815 EBF02817 EBF1280F EBF22811 EBF32813 EBF42815 EBF52817
	EBF6280F EBF72811 EBF82813 EBF92815 EBFA2817 EBFB280F EBFC2811 EBFD2813
	EBFE2815 EBFF2817 EC000078
"

constant a17 = U"00000071 536B0078 7C000871 7D0F0078"

constant a23 = U"00000057 00010078 00100057 00400078 00800083 00F80078 8000013F FFFF0078"

constant a24 = U"0000013F 7FFF0078"

-- The full set of all arrays to be searched.
constant FULL_DATA = {
	a0,
	a1,
	0,
	0,
	0,
	0,
	0,
	a7,
	a8,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	a16,
	a17,
	0,
	0,
	0,
	0,
	0,
	a23,
	a24,
	0,
	0,
	0,
	0,
	0,
	0,
	0
}

constant UCDIFF = {
	    0,   -32,   743,   121,    -1,  -232,  -300,    97,
	  163,   130,    56,    -2,   -79,  -210,  -206,  -205,
	 -202,  -203,  -207,  -209,  -211,  -213,  -214,  -218,
	 -217,  -219,   -83,    84,   -38,   -37,   -31,   -64,
	  -63,   -62,   -57,   -47,   -54,   -86,   -80,     7,
	  -96,   -48,   -59,     8,    74,    86,   100,   128,
	  112,   126,     9, -7205,   -16,   -26, -7264,   -40
}

constant LCDIFF = {
	    0,    32,     1,  -199,  -121,   210,   206,   205,
	   79,   202,   203,   207,   211,   209,   213,   214,
	  218,   217,   219,     2,   -97,   -56,  -130,  -163,
	   83,    38,    37,    64,    63,   -60,    -7,    80,
	   48,  7264,    -8,   -74,    -9,   -86,  -100,  -112,
	 -128,  -126, -7517, -8383, -8262,    16,    26,    40
}

constant TCDIFF = {
    3,     1,     0,    -1
}

constant MIRROR_DIFF = {
	    0,     1,    -1,     2,    -2,    16,   -16,     3,
	   -3,  2016,   138,  1824,  2104,  2108,  2106,  -138,
	    8,     7,    -8,    -7, -1824, -2016, -2104, -2106,
	-2108
}

constant NUMERICS = {
	    -1,      0,      1,      2,      3,      4,      5,      6,
	     7,      8,      9,     10,     11,     12,     13,     14,
	    15,     16,     17,     18,     19,     20,     21,     22,
	    23,     24,     25,     26,     27,     28,     29,     30,
	    31,     32,     33,     34,     35,     -2,    100,   1000,
	    40,     50,     60,     70,     80,     90,  10000,    500,
	  5000,     36,     37,     38,     39,     41,     42,     43,
	    44,     45,     46,     47,     48,     49,    200,    300,
	   400,    600,    700,    800,    900,   2000,   3000,   4000,
	  6000,   7000,   8000,   9000,  20000,  30000,  40000,  50000,
	 60000,  70000,  80000,  90000
}

constant NON_INTEGERS = u"
	00BC	00BD	00BE	0F2A	0F2B	0F2C	0F2D	0F2E
	0F2F	0F30	0F31	0F32	0F33	2153	2154	2155
	2156	2157	2158	2159	215A	215B	215C	215D
	215E	2CFD
	"

constant NON_INTEGER_VALS = {
	1/4,	1/2,	3/4,	1,	2,	3,	4,	5,
	6,	7,	8,	9,	0,	1/3,	2/3,	1/5,
	2/5,	3/5,	4/5,	1/6,	5/6,	1/8,	3/8,	5/8,
	7/8,	1/2,
	$}

	
--  Copied from java.lang.Character implementation:
/*
    1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
    F E D C B A 9 8 7 6 5 4 3 2 1 0 F E D C B A 9 8 7 6 5 4 3 2 1 0
                                                          --------- 31 types
                                                ---------           18 directionalities
                                              -                      2 mirrored
                                  -----------                       56  toupper diffs
                      -----------                                   48  tolower diffs
                  ---                                                4 totitlecase diffs
    -------------                                                   84 numeric values
        ---------                                                   24 mirror char diffs
*/

constant PACKED_DATA = U"
		00000000 0000012F 0000016F 0000014F 0000018F 0000018C 000001B8 000000B8
		000000BA 020005B5 040005B6 00000099 000000F8 00000094 02000069 04000069
		06000069 08000069 0A000069 0C000069 0E000069 10000069 12000069 14000069
		060005B9 000001B9 080005B9 16020001 18020001 1A020001 1C020001 1E020001
		20020001 22020001 24020001 26020001 28020001 2A020001 2C020001 2E020001
		30020001 32020001 34020001 36020001 38020001 3A020001 3C020001 3E020001
		40020001 42020001 44020001 46020001 48020001 060005B5 080005B6 000001BB
		000001B7 16000802 18000802 1A000802 1C000802 1E000802 20000802 22000802
		24000802 26000802 28000802 2A000802 2C000802 2E000802 30000802 32000802
		34000802 36000802 38000802 3A000802 3C000802 3E000802 40000802 42000802
		44000802 46000802 48000802 000000EC 000001BC 00000002 0A0005BD 00000130
		000000BC 000000B9 0600006B 0800006B 00001002 0400006B 0C0005BE 4A0001AB
		00020001 00000802 00001802 00040001 00060001 00002002 00080001 000C0001
		000E0001 00100001 00140001 00160001 00180001 00004002 00004802 00200001
		00220001 00000005 00A60001 01805802 01042003 00280001 002C0001 00000001
		00000000 00007002 00007802 00009802 0000A802 0000B802 0000C002 0000C802
		0000D002 00000004 000001A4 00000106 00320001 00340001 00360001 00380001
		0000E002 0000E802 0000F002 0000F802 00010002 00010802 00012002 00012802
		00013802 003A0001 003E0001 00013002 0000001C 00000107 00400001 00000018
		00014802 000001B4 00000038 00000025 00000050 00000058 00000045 00000044
		020000C9 060000C9 0A0000C9 0E0000C9 120000C9 000000D8 0000005C 00000008
		02000009 06000009 0A000009 0E000009 12000009 0400000B 0800000B 0000000B
		1600000B 4E00000B 00000006 4A00000B 000001B5 00420001 0600000B 0A00000B
		0E00000B 1200000B 3E00000B 5200000B 5600000B 5A00000B 5C00000B 000001B6
		2400000A 2800000A 00000010 020001AB 060001AB 0A0001AB 0E0001AB 120001AB
		00000108 00015802 00440001 00016002 00016802 00017002 00017802 00018002
		00018802 00440003 00460001 00480003 00019802 004A0001 004C0001 004E0001
		003C0001 00500001 00520001 000001BD 0000018D 000001D0 00000250 00000230
		040005BE 000000F9 0200006B 0A00006B 0E00006B 1200006B 00540001 00560001
		000005B9 045A000A 085A000A 0C5A000A 105A000A 145A000A 185A000A 525A000A
		5E5A000A 0401A00A 0801A00A 0C01A00A 1001A00A 1401A00A 1801A00A 5201A00A
		5E01A00A 4E00000A 5C00000A 0E0005B9 100005B9 020005B9 040005B9 160005B9
		180005B9 1A0005B9 200005B9 220005B9 240005B9 260005B9 040001AB 080001AB
		0C0001AB 100001AB 140001AB 180001AB 1C0001AB 200001AB 240001AB 280001AB
		0C00006B 1000006B 1400006B 1800006B 1C00006B 2000006B 2400006B 2800006B
		005C001C 0001A81C 1A0001AB 1E0001AB 220001AB 260001AB 2A0001AB 160001AB
		020005B6 100005B6 280005B9 2C0005B9 300005B9 0001B002 020005BD 0600000A
		0A00000A 0E00000A 1200000A 1600000A 3E00000A 0C00000B 1000000B 1400000B
		2E0001AB 320001AB 360001AB 3A0001AB 3E0001AB 420001AB 460001AB 640001AB
		680001AB 6A0001AB 6E0001AB 720001AB 760001AB 7A0001AB 00000013 00000012
		0000005A 000001B0 7C00000B 8000000B 8200000B 8600000B 8C00000B 6000000B
		9200000B 9600000B 9800000B 9C00000B A000000B A400000B 4A0001AA 040001AA
		520001AA 600001AA 0C0001AA 5E0001AA 160001AA 4C0001AA 4E0001AA 9E0001AA
		060001AA 8800000A 2A0001AA 005E0001 0001B802 0400002B 0800002B 1600002B
		4C00002B 00002802 00003002 000A0001 00120001 00003802 001A0001 001C0001
		001E0001 00240001 00005002 00006002 002A0001 002E0001 00300001 00006802
		00008002 00008802 00009002 0000A002 0000B002 0000D906 00011002 00011802
		00014002 040000C9 080000C9 0C0000C9 100000C9 140000C9 04000009 08000009
		0C000009 10000009 14000009 2200000B 4C00000B 2A00000B 5000000B 5400000B
		5800000B 2600000A 00015002 00019002 00000030 000001BE 0000014E 00000210
		000001F0 00580001 065A000A 0A5A000A 0E5A000A 125A000A 165A000A 1A5A000A
		4C5A000A 4E5A000A 0601A00A 0A01A00A 0E01A00A 1201A00A 1601A00A 1A01A00A
		4C01A00A 4E01A00A 6000000A 0000000A 120005B9 140005B9 1C0005B9 1E0005B9
		1600006B 1A00006B 1E00006B 2200006B 2600006B 2A00006B 0E0005B5 040005B5
		2A0005B9 2E0005B9 0200000A 0400000A 0800000A 0C00000A 1000000A 1400000A
		2A00000A 2C0001AB 300001AB 340001AB 380001AB 3C0001AB 400001AB 440001AB
		480001AB 620001AB 660001AB 500001AB 6C0001AB 700001AB 740001AB 780001AB
		520001AB 7E00000B 5E00000B 8400000B 8800000B 8A00000B 8E00000B 9000000B
		9400000B 9A00000B 9E00000B A200000B A600000B 5C0001AA 3E0001AA 7E0001AA
		0600002B 0A00002B 2A00002B 4E00002B 00000019
"

-- Character types as specified in the Unicode standard. 
-- These map directly to java.lang.Character.
enum 
    UNASSIGNED = 0,
    UPPERCASE_LETTER,
    LOWERCASE_LETTER,
    TITLECASE_LETTER,
    MODIFIER_LETTER,
    OTHER_LETTER,
    NONSPACING_MARK,
    ENCLOSING_MARK,
    COMBINING_SPACING_MARK,
    DECIMAL_DIGIT_NUMBER,
    LETTER_NUMBER,
    OTHER_NUMBER,
    SPACE_SEPARATOR,
    LINE_SEPARATOR,
    PARAGRAPH_SEPARATOR,
    CONTROL,
    FORMAT,
    NOT_ASSIGNED,
    PRIVATE_USE,
    SURROGATE,
    DASH_PUNCTUATION,
    OPEN_PUNCTUATION,
    CLOSE_PUNCTUATION,
    CONNECTOR_PUNCTUATION,
    OTHER_PUNCTUATION,
    MATH_SYMBOL,
    CURRENCY_SYMBOL,
    MODIFIER_SYMBOL,
    OTHER_SYMBOL,
    INITIAL_QUOTE_PUNCTUATION,
    FINAL_QUOTE_PUNCTUATION


-- Decomposition types as described by the unicode standard. 
-- These values map to the same values in dchar.h in ICU.
enum
	NONE = 0,
	CANONICAL,
	COMPAT,
	CIRCLE,
	FINAL,
	FONT,
	FRACTION,
	INITIAL,
	ISOLATED,
	MEDIAL,
	NARROW,
	NOBREAK,
	SMALL,
	SQUARE,
	SUB,
	SUPER,
	VERTICAL,
	WIDE


enum 
	TYPE_SHIFT			= 0,
	TYPE_MASK			= 0b1_1111,

	DIRECTION_SHIFT		= 5, --TYPE_SHIFT + 5
	DIRECTION_MASK		= 0b1_1111,

	MIRRORED_SHIFT		= 10, -- DIRECTION_SHIFT + 5
	MIRRORED_MASK		= 0b1,

	TOUPPER_SHIFT		= 11, -- MIRRORED_SHIFT + 1
	TOUPPER_MASK		= 0b11_1111,

	TOLOWER_SHIFT		= 17, -- TOUPPER_SHIFT + 6
	TOLOWER_MASK		= 0b11_1111,

	TOTITLE_SHIFT		= 23, --TOLOWER_SHIFT + 6
	TOTITLE_MASK		= 0b11,

	MIRROR_SHIFT		= 25, -- TOTITLE_SHIFT + 2
	MIRROR_MASK			= 0b1_1111,

	NUMERIC_SHIFT		= 25, -- TOTITLE_SHIFT + 2
	NUMERIC_MASK		= 0b111_1111,

	DECOMPOSITION_SHIFT	= 11,
	DECOMPOSITION_MASK	= 0b1_1111

-- Directions specified in the Unicode standard. These directions map directly
-- to java.lang.Character.
enum
	UNDEFINED = -1,
	LEFT_TO_RIGHT,
	RIGHT_TO_LEFT,
	RIGHT_TO_LEFT_ARABIC,
	EUROPEAN_NUMBER,
	EUROPEAN_NUMBER_SEPARATOR,
	EUROPEAN_NUMBER_TERMINATOR,
	ARABIC_NUMBER,
	COMMON_NUMBER_SEPARATOR,
	DIR_NONSPACING_MARK,
	BOUNDARY_NEUTRAL,
	BLOCK_SEPARATOR,
	SEGMENT_SEPARATOR,
	WHITESPACE,
	OTHER_NEUTRALS,
	LEFT_TO_RIGHT_EMBEDDING,
	LEFT_TO_RIGHT_OVERRIDE,
	RIGHT_TO_LEFT_EMBEDDING,
	RIGHT_TO_LEFT_OVERRIDE,
	POP_DIRECTIONAL_FORMAT,
	$



function findCharacterValue(atom c)
	if c > 0x10FFFF then
		return -1
	end if
	
	if c < 0 then
		return -1
	end if
	
	if c <= 0xFF then
		return LATIN1_DATA[c + 1]
	end if
	

	-- Rotate the bits because the tables are separated into even and odd
	-- codepoints
	atom u = or_bits(shift_bits(c, 1), shift_bits(and_bits(c, 1), -20))

	atom idx 
	idx = shift_bits(u, 16) + 1
	object array = FULL_DATA[idx]
	if atom(array) then
		return 0
	end if

	-- This trick is so that that compare in the while loop does not need to
	-- shift the array entry down by 16
	u = shift_bits(u, -16)
	u = or_bits(u, 0xFFFF)

	integer high = length(array)
	integer low = 1

	while (low < high - 1) do
		integer probe = floor((high + low + 1) / 2)

		-- The entries contain the codepoint in the high 16 bits and the index
		-- into PACKED_DATA in the low 16.
		if array[probe] > u then
			high = probe
		else
			low = probe
		end if
	end while

	idx = array[low]
	if idx > u then
		return -1
	end if

	return and_bits(array[low], 0xFFFF)
end function

function getPackedData(atom c) 
	-- findCharacterValue returns a 16-bit value with the top 5 bits containing
	-- a decomposition type and the remaining bits containing an index.
	return PACKED_DATA[1 + and_bits(findCharacterValue(c), 0x7FF)]
end function


function getType(atom ucs_char)
	if ucs_char >= 0x10FFFF then
		return UNASSIGNED
	end if
	
	return and_bits(shift_bits(getPackedData(ucs_char), TYPE_SHIFT), TYPE_MASK)
end function

function getDirectionality(atom c)
	atom data = getPackedData(c)

	if not data then
		return UNDEFINED
	end if

	integer d = and_bits(shift_bits(data, DIRECTION_SHIFT), DIRECTION_MASK)

	return iff( d != DIRECTION_MASK, d , UNDEFINED)
end function

--**
-- The code point is a 'letter'.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isAlpha(atom ucs_char)
	if ucs_char <= 0x7F then
		return t_alpha(ucs_char)
	end if

	
	switch getType(ucs_char) do
		case UPPERCASE_LETTER,
		     LOWERCASE_LETTER,
		     TITLECASE_LETTER,
		     MODIFIER_LETTER,
		     OTHER_LETTER then
			return TRUE
	
		case else
			return FALSE
	end switch
end function

--**
-- The code point is an uppercase 'letter'.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isUpper(atom ucs_char)
	if ucs_char <= 0x7F then
		return t_upper(ucs_char)
	end if
	
	return (getType(ucs_char) = UPPERCASE_LETTER)
end function


--**
-- The code point is a lowercase 'letter'.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isLower(atom ucs_char)
	if ucs_char <= 0x7F then
		return t_lower(ucs_char)
	end if
	
	return (getType(ucs_char) = LOWERCASE_LETTER)
end function

--**
-- The code point is a Title case 'letter'.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isTitle(atom ucs_char)
	if ucs_char <= 0x7F then
		return t_upper(ucs_char)
	end if
	
	return (getType(ucs_char) = TITLECASE_LETTER)
end function

--**
-- The code point is either a 'letter' or a 'digit'.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isAlphaNum(atom ucs_char)
	if ucs_char <= 0x7F then
		return t_alnum(ucs_char)
	end if

	
	switch getType(ucs_char) do
		case UPPERCASE_LETTER,
		     LOWERCASE_LETTER,
		     TITLECASE_LETTER,
		     MODIFIER_LETTER,
		     OTHER_LETTER,
		     DECIMAL_DIGIT_NUMBER
		      then
			return TRUE
	
		case else
			return FALSE
	end switch
end function

--**
-- The code point is a 'digit'.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isDigit(atom ucs_char)
	if ucs_char <= 0x7F then
		return t_digit(ucs_char)
	end if

	
	switch getType(ucs_char) do
		case DECIMAL_DIGIT_NUMBER then
			return TRUE
	
		case else
			return FALSE
	end switch
end function

--**
-- The code point is a 'number'. Some code points represent fractional numbers.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isNumber(atom ucs_char)
	if ucs_char <= 0x7F then
		return t_digit(ucs_char)
	end if

	
	switch getType(ucs_char) do
		case DECIMAL_DIGIT_NUMBER,
			LETTER_NUMBER,
			OTHER_NUMBER
			then
			return TRUE
	
		case else
			return FALSE
	end switch
end function


--**
-- The code point is a word separator.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isSeparator(atom ucs_char)
	if ucs_char <= 0x7F then
		return t_space(ucs_char)
	end if

	
	switch getType(ucs_char) do
		case SPACE_SEPARATOR,
		     LINE_SEPARATOR,
		     PARAGRAPH_SEPARATOR
		      then
			return TRUE
	
		case else
			return FALSE
	end switch
end function

--**
-- The code point is a 'space' character.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isSpace(atom ucs_char)
	if ucs_char <= 0x7F then
		return t_space(ucs_char)
	end if

	
	switch getType(ucs_char) do
		case SPACE_SEPARATOR
		      then
			return TRUE
	
		case else
			return FALSE
	end switch
end function

--**
-- The code point is a line separator.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isLine(atom ucs_char)

	
	switch getType(ucs_char) do
		case LINE_SEPARATOR
		      then
			return TRUE
	
		case else
			return FALSE
	end switch
end function

--**
-- The code point is a paragraph separator
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isParagraph(atom ucs_char)

	
	switch getType(ucs_char) do
		case PARAGRAPH_SEPARATOR
		      then
			return TRUE
	
		case else
			return FALSE
	end switch
end function

--**
-- The code point is a textual 'marker'.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isMark(atom ucs_char)

	
	switch getType(ucs_char) do
		case NONSPACING_MARK,
			COMBINING_SPACING_MARK,
			ENCLOSING_MARK
		      then
			return TRUE
	
		case else
			return FALSE
	end switch
end function

--**
-- The code point is a non-spacing letter.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isNonSpacing(atom ucs_char)

	
	switch getType(ucs_char) do
		case NONSPACING_MARK
		      then
			return TRUE
	
		case else
			return FALSE
	end switch
end function


--**
-- The code point is a punctuation mark.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isPunctuation(atom ucs_char)

	if ucs_char <= 0x7F then
		return t_punct(ucs_char)
	end if
	
	
	switch getType(ucs_char) do
		case
			CONNECTOR_PUNCTUATION,
			DASH_PUNCTUATION,
			OPEN_PUNCTUATION,
			CLOSE_PUNCTUATION,
			INITIAL_QUOTE_PUNCTUATION,
			FINAL_QUOTE_PUNCTUATION,
			OTHER_PUNCTUATION
		      then
			return TRUE
	
		case else
			return FALSE
	end switch
end function

--**
-- The code point is a 'symbol'.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isSymbol(atom ucs_char)
	switch getType(ucs_char) do
		case
			MATH_SYMBOL,
			CURRENCY_SYMBOL,
			MODIFIER_SYMBOL,
			OTHER_SYMBOL
		      then
			return TRUE
	
		case else
			return FALSE
	end switch
end function

--**
-- The code point is a 'symbol'.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isCurrency(atom ucs_char)
	return getType(ucs_char) = CURRENCY_SYMBOL
end function


--**
-- The code point is a functional item, such as a control character, or private-use.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isOther(atom ucs_char)
	switch getType(ucs_char) do
		case
			CONTROL,
			FORMAT,
			SURROGATE,
			PRIVATE_USE,
			NOT_ASSIGNED
		      then
			return TRUE
	
		case else
			return FALSE
	end switch
end function

--**
-- The code point is a control item.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isControl(atom ucs_char)
	if ucs_char <= 0x7F then
		return t_cntrl(ucs_char)
	end if
	return getType(ucs_char) = CONTROL
end function

--**
-- The code point is a formatting item.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isFormat(atom ucs_char)
	return getType(ucs_char) = FORMAT
end function

--**
-- The code point is a surrogate code.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isSurrogate(atom ucs_char)
	return getType(ucs_char) = SURROGATE
end function

--**
-- The code point is a private-use item.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isPrivate(atom ucs_char)
	return getType(ucs_char) = PRIVATE_USE
end function

--**
-- The code point is a character with a glyph.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isGraph(atom ucs_char)
	if ucs_char <= 0x7F then
		return t_graph(ucs_char)
	end if
	switch getType(ucs_char) do
		case
			UPPERCASE_LETTER,
			LOWERCASE_LETTER,
			TITLECASE_LETTER,
			MODIFIER_LETTER,
			OTHER_LETTER,
			DECIMAL_DIGIT_NUMBER,
			LETTER_NUMBER,
			OTHER_NUMBER,
			NONSPACING_MARK,
			COMBINING_SPACING_MARK,
			ENCLOSING_MARK,
			CONNECTOR_PUNCTUATION,
			DASH_PUNCTUATION,
			OPEN_PUNCTUATION,
			CLOSE_PUNCTUATION,
			INITIAL_QUOTE_PUNCTUATION,
			FINAL_QUOTE_PUNCTUATION,
			OTHER_PUNCTUATION,
			MATH_SYMBOL,
			CURRENCY_SYMBOL,
			MODIFIER_SYMBOL,
			OTHER_SYMBOL
		      then
			return TRUE
	
		case else
			return FALSE
	end switch
end function

--**
-- The code point is a character that is printable.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isPrint(atom ucs_char)
	if ucs_char <= 0x7F then
		return t_print(ucs_char)
	end if
	switch getType(ucs_char) do
		case
			UPPERCASE_LETTER,
			LOWERCASE_LETTER,
			TITLECASE_LETTER,
			MODIFIER_LETTER,
			OTHER_LETTER,
			DECIMAL_DIGIT_NUMBER,
			LETTER_NUMBER,
			OTHER_NUMBER,
			SPACE_SEPARATOR,
			NONSPACING_MARK,
			COMBINING_SPACING_MARK,
			ENCLOSING_MARK,
			CONNECTOR_PUNCTUATION,
			DASH_PUNCTUATION,
			OPEN_PUNCTUATION,
			CLOSE_PUNCTUATION,
			INITIAL_QUOTE_PUNCTUATION,
			FINAL_QUOTE_PUNCTUATION,
			OTHER_PUNCTUATION,
			MATH_SYMBOL,
			CURRENCY_SYMBOL,
			MODIFIER_SYMBOL,
			OTHER_SYMBOL
		      then
			return TRUE
	
		case else
			return FALSE
	end switch
end function


--**
-- The code point is a directional white space character.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isDirWhiteSpace(atom ucs_char)
	return getDirectionality(ucs_char) = WHITESPACE
end function

--**
-- The code point is a left-to-right character.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isDirLTR(atom ucs_char)
	return getDirectionality(ucs_char) = LEFT_TO_RIGHT
end function

--**
-- The code point is a right-to-left character.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isDirRTL(atom ucs_char)
	return getDirectionality(ucs_char) = RIGHT_TO_LEFT
end function

--**
-- The code point has an exact directional aspect. It must be always be LtR or RtL.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isDirStrong(atom ucs_char)
	switch getDirectionality(ucs_char) do
		case 
			RIGHT_TO_LEFT,
			LEFT_TO_RIGHT
			then
			return TRUE
			
		case else
			return FALSE
	end switch
end function

--**
-- The code point has an implied directional aspect, that depends on context.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isDirWeak(atom ucs_char)
	switch getDirectionality(ucs_char) do
		case 
			EUROPEAN_NUMBER,
			EUROPEAN_NUMBER_SEPARATOR,
			EUROPEAN_NUMBER_TERMINATOR,
			ARABIC_NUMBER,
			COMMON_NUMBER_SEPARATOR
			then
			return TRUE
			
		case else
			return FALSE
	end switch
end function

--**
-- The code point has no directional aspect.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isDirNeutral(atom ucs_char)
	switch getDirectionality(ucs_char) do
		case 
			BLOCK_SEPARATOR,
			SEGMENT_SEPARATOR,
			WHITESPACE,
			OTHER_NEUTRALS
			then
			return TRUE
			
		case else
			return FALSE
	end switch
end function

--**
-- The code point is a directional separator.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isDirSeparator(atom ucs_char)
	switch getDirectionality(ucs_char) do
		case 
			BLOCK_SEPARATOR,
			SEGMENT_SEPARATOR
			then
			return TRUE
			
		case else
			return FALSE
	end switch
end function


--**
-- The code point is a block separator.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isBlock(atom ucs_char)
	return getDirectionality(ucs_char) = BLOCK_SEPARATOR
end function


--**
-- The code point is a segment separator.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--

public function isSegment(atom ucs_char)
	return getDirectionality(ucs_char) = SEGMENT_SEPARATOR
end function


--**
-- The code point is a non-breaking character.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--
public function isNonBreaking(atom ucs_char)
	return NOBREAK = and_bits(
				shift_bits(findCharacterValue(ucs_char), DECOMPOSITION_SHIFT),
				DECOMPOSITION_MASK)
end function

--**
-- The code point has a mirror (matching) character, such as parenthesis.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to test.
-- 
-- Returns:
-- TRUE when ##ucs_char## is in the set, FALSE otherwise.
--
public function isMirroring(atom ucs_char)
	return and_bits(shift_bits(getPackedData(ucs_char), MIRRORED_SHIFT), MIRRORED_MASK) != 0
end function

--**
-- Converts the input to lower case.
--
-- Parameters:
-- # ##ucs_char##: An object. Either a single code point to convert or a text string.
-- 
-- Returns:
-- The converted input.
--
public function toLower(object ucs_char)
	if atom(ucs_char) then
		return ucs_char + LCDIFF[1 + and_bits(shift_bits(getPackedData(ucs_char), TOLOWER_SHIFT), TOLOWER_MASK)]
	end if
	
	for i = 1 to length(ucs_char) do
		ucs_char[i] = toLower(ucs_char[i])
	end for
	
	return ucs_char
end function

--**
-- Converts the input to upperer case.
--
-- Parameters:
-- # ##ucs_char##: An object. Either a single code point to convert or a text string.
-- 
-- Returns:
-- The converted input.
--
public function toUpper(object ucs_char)
	if atom(ucs_char) then
		return ucs_char + UCDIFF[1 + and_bits(shift_bits(getPackedData(ucs_char), TOUPPER_SHIFT), TOUPPER_MASK)]
	end if
	
	for i = 1 to length(ucs_char) do
		ucs_char[i] = toUpper(ucs_char[i])
	end for
	
	return ucs_char
end function

--**
-- Converts the input to lower case.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to convert.
-- 
-- Returns:
-- The converted input.
--
public function toTitle(atom ucs_char)
	integer diff = TCDIFF[1 + and_bits(shift_bits(getPackedData(ucs_char), TOTITLE_SHIFT), TOTITLE_MASK)]
	return iff( diff != TOTITLE_MASK, ucs_char + diff , toUpper(ucs_char))
end function

--**
-- Gets the matching charater for the supplied code point.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to match.
-- 
-- Returns:
-- If the code point has no matching value, the code point is returned, otherwise
-- the matching (mirror) code point is returned.
--
public function toMirror(atom ucs_char)
	if not isMirroring(ucs_char) then
		return ucs_char
	end if

	return ucs_char + MIRROR_DIFF[1 + and_bits(shift_bits(getPackedData(ucs_char), MIRROR_SHIFT), MIRROR_MASK)]
end function

--**
-- Gets the numerical value of the character.
--
-- Parameters:
-- # ##ucs_char##: An atom. The code point to convert.
-- 
-- Returns:
-- An atom: -1 if the code point has no numerical value,
-- -2 if the value is not known, otherwise the numerical value of it.
--
public function getNumericValue(atom ucs_char)
	if isMirroring(ucs_char) then
		return -1
	end if
	atom val = NUMERICS[1 + and_bits(shift_bits(getPackedData(ucs_char), NUMERIC_SHIFT), NUMERIC_MASK)]
	if val = -2 then
		val = find(ucs_char, NON_INTEGERS)
		if val != 0 then
			val = NON_INTEGER_VALS[val]
		else
			val = -2
		end if
	end if
	
	return val
end function

ifdef UCSTYPE_DEBUG then
-- DEBUG TESTING
-- This creates a file containing all the code ranges for each category.
sequence p = {
	routine_id("isAlpha"),
	routine_id("isUpper"),
	routine_id("isLower"),
	routine_id("isTitle"),
	routine_id("isAlphaNum"),
	routine_id("isDigit"),
	routine_id("isNumber"),
	routine_id("isSeparator"),
	routine_id("isSpace"),
	routine_id("isLine"),
	routine_id("isParagraph"),
	routine_id("isMark"),
	routine_id("isNonSpacing"),
	routine_id("isPunctuation"),
	routine_id("isSymbol"),
	routine_id("isCurrency"),
	routine_id("isOther"),
	routine_id("isControl"),
	routine_id("isFormat"),
	routine_id("isSurrogate"),
	routine_id("isPrivate"),
	routine_id("isGraph"),
	routine_id("isPrint"),
	routine_id("isDirWhiteSpace"),
	routine_id("isDirLTR"),
	routine_id("isDirRTL"),
	routine_id("isDirStrong"),
	routine_id("isDirWeak"),
	routine_id("isDirNeutral"),
	routine_id("isDirSeparator"),
	routine_id("isNonBreaking"),
	routine_id("isMirroring"),
	$
}
sequence r
integer ix
integer c
integer fh = open("ucstest.txt", "w")
for k = 1 to length(p) do
	c = p[k]
	
	r = {-1,-1}
	ix = 1
	
	for i = 0 to 0xFFFF do
		integer res 
		
		res = call_func(c, {i})
		if res then
			if ix = 1 then
				r[1] = i
				ix = 2
			else
				if r[2] = -1 then
					r[2] = i
				elsif r[2] != i-1 then
					printf(fh, "%2d %06x:%06x\n", c & r)
					r = {i, -1}
				else
					r[2] = i
				end if
			end if
		else
			if r[1] != -1 then
				if r[2] != -1 then
					printf(fh, "%2d %06x:%06x\n", c & r)
				else
					printf(fh, "%2d %06x\n", c & r[1])
				end if
			end if
			r = {-1, -1}
			ix = 1
		end if
	end for
	if r[1] != -1 then
		if r[2] != -1 then
			printf(fh, "%2d %06x:%06x\n", c & r)
		else
			printf(fh, "%2d %06x\n", c & r[1])
		end if
	end if
	puts(fh, "\n\n")
end for
	
close(fh)
end ifdef
